// $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/verunilibs/data/stan/MCB.v,v 1.12 2010/02/04 20:56:22 vandanad Exp $
///////////////////////////////////////////////////////
//  Copyright (c) 2008 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /     Vendor      : Xilinx 
// \  \    \/      Version : 10.1
//  \  \           Description : 
//  /  /                      
// /__/   /\       Filename    : MCB.v
// \  \  /  \ 
//  \__\/\__ \                    
//                                 
//  Generated by :	/home/chen/xfoundry/HEAD/env/Databases/CAEInterfaces/LibraryWriters/bin/write_verilog.pl
//  Revision:		1.0
//  1016  - Added memory type based parameter checks and set uiclk-ioidrpclk path delay to 0.
//  520730 - Remove UICLK-> IOIDRPTRAIN path from specify block.
//  532287 - Change default value of parameter CAL_CALIBRATION_MODE.
//  545576 - MEM_MDDR_ODS attribute update.
///////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module MCB (
  ADDR,
  BA,
  CAS,
  CKE,
  DQIOWEN0,
  DQON,
  DQOP,
  DQSIOWEN90N,
  DQSIOWEN90P,
  IOIDRPADD,
  IOIDRPADDR,
  IOIDRPBROADCAST,
  IOIDRPCLK,
  IOIDRPCS,
  IOIDRPSDO,
  IOIDRPTRAIN,
  IOIDRPUPDATE,
  LDMN,
  LDMP,
  ODT,
  P0CMDEMPTY,
  P0CMDFULL,
  P0RDCOUNT,
  P0RDDATA,
  P0RDEMPTY,
  P0RDERROR,
  P0RDFULL,
  P0RDOVERFLOW,
  P0WRCOUNT,
  P0WREMPTY,
  P0WRERROR,
  P0WRFULL,
  P0WRUNDERRUN,
  P1CMDEMPTY,
  P1CMDFULL,
  P1RDCOUNT,
  P1RDDATA,
  P1RDEMPTY,
  P1RDERROR,
  P1RDFULL,
  P1RDOVERFLOW,
  P1WRCOUNT,
  P1WREMPTY,
  P1WRERROR,
  P1WRFULL,
  P1WRUNDERRUN,
  P2CMDEMPTY,
  P2CMDFULL,
  P2COUNT,
  P2EMPTY,
  P2ERROR,
  P2FULL,
  P2RDDATA,
  P2RDOVERFLOW,
  P2WRUNDERRUN,
  P3CMDEMPTY,
  P3CMDFULL,
  P3COUNT,
  P3EMPTY,
  P3ERROR,
  P3FULL,
  P3RDDATA,
  P3RDOVERFLOW,
  P3WRUNDERRUN,
  P4CMDEMPTY,
  P4CMDFULL,
  P4COUNT,
  P4EMPTY,
  P4ERROR,
  P4FULL,
  P4RDDATA,
  P4RDOVERFLOW,
  P4WRUNDERRUN,
  P5CMDEMPTY,
  P5CMDFULL,
  P5COUNT,
  P5EMPTY,
  P5ERROR,
  P5FULL,
  P5RDDATA,
  P5RDOVERFLOW,
  P5WRUNDERRUN,
  RAS,
  RST,
  SELFREFRESHMODE,
  STATUS,
  UDMN,
  UDMP,
  UOCALSTART,
  UOCMDREADYIN,
  UODATA,
  UODATAVALID,
  UODONECAL,
  UOREFRSHFLAG,
  UOSDO,
  WE,
  DQI,
  DQSIOIN,
  DQSIOIP,
  IOIDRPSDI,
  P0ARBEN,
  P0CMDBA,
  P0CMDBL,
  P0CMDCA,
  P0CMDCLK,
  P0CMDEN,
  P0CMDINSTR,
  P0CMDRA,
  P0RDCLK,
  P0RDEN,
  P0RWRMASK,
  P0WRCLK,
  P0WRDATA,
  P0WREN,
  P1ARBEN,
  P1CMDBA,
  P1CMDBL,
  P1CMDCA,
  P1CMDCLK,
  P1CMDEN,
  P1CMDINSTR,
  P1CMDRA,
  P1RDCLK,
  P1RDEN,
  P1RWRMASK,
  P1WRCLK,
  P1WRDATA,
  P1WREN,
  P2ARBEN,
  P2CLK,
  P2CMDBA,
  P2CMDBL,
  P2CMDCA,
  P2CMDCLK,
  P2CMDEN,
  P2CMDINSTR,
  P2CMDRA,
  P2EN,
  P2WRDATA,
  P2WRMASK,
  P3ARBEN,
  P3CLK,
  P3CMDBA,
  P3CMDBL,
  P3CMDCA,
  P3CMDCLK,
  P3CMDEN,
  P3CMDINSTR,
  P3CMDRA,
  P3EN,
  P3WRDATA,
  P3WRMASK,
  P4ARBEN,
  P4CLK,
  P4CMDBA,
  P4CMDBL,
  P4CMDCA,
  P4CMDCLK,
  P4CMDEN,
  P4CMDINSTR,
  P4CMDRA,
  P4EN,
  P4WRDATA,
  P4WRMASK,
  P5ARBEN,
  P5CLK,
  P5CMDBA,
  P5CMDBL,
  P5CMDCA,
  P5CMDCLK,
  P5CMDEN,
  P5CMDINSTR,
  P5CMDRA,
  P5EN,
  P5WRDATA,
  P5WRMASK,
  PLLCE,
  PLLCLK,
  PLLLOCK,
  RECAL,
  SELFREFRESHENTER,
  SYSRST,
  UDQSIOIN,
  UDQSIOIP,
  UIADD,
  UIADDR,
  UIBROADCAST,
  UICLK,
  UICMD,
  UICMDEN,
  UICMDIN,
  UICS,
  UIDONECAL,
  UIDQCOUNT,
  UIDQLOWERDEC,
  UIDQLOWERINC,
  UIDQUPPERDEC,
  UIDQUPPERINC,
  UIDRPUPDATE,
  UILDQSDEC,
  UILDQSINC,
  UIREAD,
  UISDI,
  UIUDQSDEC,
  UIUDQSINC
);

  parameter integer ARB_NUM_TIME_SLOTS = 12;
  parameter [17:0] ARB_TIME_SLOT_0 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_1 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_10 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_11 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_2 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_3 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_4 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_5 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_6 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_7 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_8 = 18'b111111111111111111;
  parameter [17:0] ARB_TIME_SLOT_9 = 18'b111111111111111111;
  parameter [2:0] CAL_BA = 3'h0;
  parameter CAL_BYPASS = "YES";
  parameter [11:0] CAL_CA = 12'h000;
  parameter CAL_CALIBRATION_MODE = "NOCALIBRATION";
  parameter integer CAL_CLK_DIV = 1;
  parameter CAL_DELAY = "QUARTER";
  parameter [14:0] CAL_RA = 15'h0000;
  parameter MEM_ADDR_ORDER = "BANK_ROW_COLUMN";
  parameter integer MEM_BA_SIZE = 3;
  parameter integer MEM_BURST_LEN = 8;
  parameter integer MEM_CAS_LATENCY = 4;
  parameter integer MEM_CA_SIZE = 11;
  parameter MEM_DDR1_2_ODS = "FULL";
  parameter MEM_DDR2_3_HIGH_TEMP_SR = "NORMAL";
  parameter MEM_DDR2_3_PA_SR = "FULL";
  parameter integer MEM_DDR2_ADD_LATENCY = 0;
  parameter MEM_DDR2_DIFF_DQS_EN = "YES";
  parameter MEM_DDR2_RTT = "50OHMS";
  parameter integer MEM_DDR2_WRT_RECOVERY = 4;
  parameter MEM_DDR3_ADD_LATENCY = "OFF";
  parameter MEM_DDR3_AUTO_SR = "ENABLED";
  parameter integer MEM_DDR3_CAS_LATENCY = 7;
  parameter integer MEM_DDR3_CAS_WR_LATENCY = 5;
  parameter MEM_DDR3_DYN_WRT_ODT = "OFF";
  parameter MEM_DDR3_ODS = "DIV7";
  parameter MEM_DDR3_RTT = "DIV2";
  parameter integer MEM_DDR3_WRT_RECOVERY = 7;
  parameter MEM_MDDR_ODS = "FULL";
  parameter MEM_MOBILE_PA_SR = "FULL";
  parameter integer MEM_MOBILE_TC_SR = 0;
  parameter integer MEM_RAS_VAL = 0;
  parameter integer MEM_RA_SIZE = 13;
  parameter integer MEM_RCD_VAL = 1;
  parameter integer MEM_REFI_VAL = 0;
  parameter integer MEM_RFC_VAL = 0;
  parameter integer MEM_RP_VAL = 0;
  parameter integer MEM_RTP_VAL = 0;
  parameter MEM_TYPE = "DDR3";
  parameter integer MEM_WIDTH = 4;
  parameter integer MEM_WR_VAL = 0;
  parameter integer MEM_WTR_VAL = 3;
  parameter PORT_CONFIG = "B32_B32_B32_B32";
  
  localparam in_delay = 0;
  localparam out_delay = 0;
  localparam INCLK_DELAY = 0;
  localparam OUTCLK_DELAY = 0;

  output CAS;
  output CKE;
  output DQIOWEN0;
  output DQSIOWEN90N;
  output DQSIOWEN90P;
  output IOIDRPADD;
  output IOIDRPBROADCAST;
  output IOIDRPCLK;
  output IOIDRPCS;
  output IOIDRPSDO;
  output IOIDRPTRAIN;
  output IOIDRPUPDATE;
  output LDMN;
  output LDMP;
  output ODT;
  output P0CMDEMPTY;
  output P0CMDFULL;
  output P0RDEMPTY;
  output P0RDERROR;
  output P0RDFULL;
  output P0RDOVERFLOW;
  output P0WREMPTY;
  output P0WRERROR;
  output P0WRFULL;
  output P0WRUNDERRUN;
  output P1CMDEMPTY;
  output P1CMDFULL;
  output P1RDEMPTY;
  output P1RDERROR;
  output P1RDFULL;
  output P1RDOVERFLOW;
  output P1WREMPTY;
  output P1WRERROR;
  output P1WRFULL;
  output P1WRUNDERRUN;
  output P2CMDEMPTY;
  output P2CMDFULL;
  output P2EMPTY;
  output P2ERROR;
  output P2FULL;
  output P2RDOVERFLOW;
  output P2WRUNDERRUN;
  output P3CMDEMPTY;
  output P3CMDFULL;
  output P3EMPTY;
  output P3ERROR;
  output P3FULL;
  output P3RDOVERFLOW;
  output P3WRUNDERRUN;
  output P4CMDEMPTY;
  output P4CMDFULL;
  output P4EMPTY;
  output P4ERROR;
  output P4FULL;
  output P4RDOVERFLOW;
  output P4WRUNDERRUN;
  output P5CMDEMPTY;
  output P5CMDFULL;
  output P5EMPTY;
  output P5ERROR;
  output P5FULL;
  output P5RDOVERFLOW;
  output P5WRUNDERRUN;
  output RAS;
  output RST;
  output SELFREFRESHMODE;
  output UDMN;
  output UDMP;
  output UOCALSTART;
  output UOCMDREADYIN;
  output UODATAVALID;
  output UODONECAL;
  output UOREFRSHFLAG;
  output UOSDO;
  output WE;
  output [14:0] ADDR;
  output [15:0] DQON;
  output [15:0] DQOP;
  output [2:0] BA;
  output [31:0] P0RDDATA;
  output [31:0] P1RDDATA;
  output [31:0] P2RDDATA;
  output [31:0] P3RDDATA;
  output [31:0] P4RDDATA;
  output [31:0] P5RDDATA;
  output [31:0] STATUS;
  output [4:0] IOIDRPADDR;
  output [6:0] P0RDCOUNT;
  output [6:0] P0WRCOUNT;
  output [6:0] P1RDCOUNT;
  output [6:0] P1WRCOUNT;
  output [6:0] P2COUNT;
  output [6:0] P3COUNT;
  output [6:0] P4COUNT;
  output [6:0] P5COUNT;
  output [7:0] UODATA;

  input DQSIOIN;
  input DQSIOIP;
  input IOIDRPSDI;
  input P0ARBEN;
  input P0CMDCLK;
  input P0CMDEN;
  input P0RDCLK;
  input P0RDEN;
  input P0WRCLK;
  input P0WREN;
  input P1ARBEN;
  input P1CMDCLK;
  input P1CMDEN;
  input P1RDCLK;
  input P1RDEN;
  input P1WRCLK;
  input P1WREN;
  input P2ARBEN;
  input P2CLK;
  input P2CMDCLK;
  input P2CMDEN;
  input P2EN;
  input P3ARBEN;
  input P3CLK;
  input P3CMDCLK;
  input P3CMDEN;
  input P3EN;
  input P4ARBEN;
  input P4CLK;
  input P4CMDCLK;
  input P4CMDEN;
  input P4EN;
  input P5ARBEN;
  input P5CLK;
  input P5CMDCLK;
  input P5CMDEN;
  input P5EN;
  input PLLLOCK;
  input RECAL;
  input SELFREFRESHENTER;
  input SYSRST;
  input UDQSIOIN;
  input UDQSIOIP;
  input UIADD;
  input UIBROADCAST;
  input UICLK;
  input UICMD;
  input UICMDEN;
  input UICMDIN;
  input UICS;
  input UIDONECAL;
  input UIDQLOWERDEC;
  input UIDQLOWERINC;
  input UIDQUPPERDEC;
  input UIDQUPPERINC;
  input UIDRPUPDATE;
  input UILDQSDEC;
  input UILDQSINC;
  input UIREAD;
  input UISDI;
  input UIUDQSDEC;
  input UIUDQSINC;
  input [11:0] P0CMDCA;
  input [11:0] P1CMDCA;
  input [11:0] P2CMDCA;
  input [11:0] P3CMDCA;
  input [11:0] P4CMDCA;
  input [11:0] P5CMDCA;
  input [14:0] P0CMDRA;
  input [14:0] P1CMDRA;
  input [14:0] P2CMDRA;
  input [14:0] P3CMDRA;
  input [14:0] P4CMDRA;
  input [14:0] P5CMDRA;
  input [15:0] DQI;
  input [1:0] PLLCE;
  input [1:0] PLLCLK;
  input [2:0] P0CMDBA;
  input [2:0] P0CMDINSTR;
  input [2:0] P1CMDBA;
  input [2:0] P1CMDINSTR;
  input [2:0] P2CMDBA;
  input [2:0] P2CMDINSTR;
  input [2:0] P3CMDBA;
  input [2:0] P3CMDINSTR;
  input [2:0] P4CMDBA;
  input [2:0] P4CMDINSTR;
  input [2:0] P5CMDBA;
  input [2:0] P5CMDINSTR;
  input [31:0] P0WRDATA;
  input [31:0] P1WRDATA;
  input [31:0] P2WRDATA;
  input [31:0] P3WRDATA;
  input [31:0] P4WRDATA;
  input [31:0] P5WRDATA;
  input [3:0] P0RWRMASK;
  input [3:0] P1RWRMASK;
  input [3:0] P2WRMASK;
  input [3:0] P3WRMASK;
  input [3:0] P4WRMASK;
  input [3:0] P5WRMASK;
  input [3:0] UIDQCOUNT;
  input [4:0] UIADDR;
  input [5:0] P0CMDBL;
  input [5:0] P1CMDBL;
  input [5:0] P2CMDBL;
  input [5:0] P3CMDBL;
  input [5:0] P4CMDBL;
  input [5:0] P5CMDBL;

  reg ARB_NUM_TIME_SLOTS_BINARY;
  reg CAL_BYPASS_BINARY;
  reg CAL_CALIBRATION_MODE_BINARY;
  reg MEM_ADDR_ORDER_BINARY;
  reg MEM_BA_SIZE_BINARY;
  reg MEM_BURST_LEN_BINARY;
  reg MEM_DDR1_2_ODS_BINARY;
  reg MEM_DDR2_3_HIGH_TEMP_SR_BINARY;
  reg MEM_DDR2_DIFF_DQS_EN_BINARY;
  reg MEM_DDR3_AUTO_SR_BINARY;
  reg [2:0] PORT_CONFIG_BINARY;
  reg [11:0] MEM_REFI_VAL_BINARY;
  reg [17:0] ARB_TIME_SLOT_0_BINARY;
  reg [17:0] ARB_TIME_SLOT_10_BINARY;
  reg [17:0] ARB_TIME_SLOT_11_BINARY;
  reg [17:0] ARB_TIME_SLOT_1_BINARY;
  reg [17:0] ARB_TIME_SLOT_2_BINARY;
  reg [17:0] ARB_TIME_SLOT_3_BINARY;
  reg [17:0] ARB_TIME_SLOT_4_BINARY;
  reg [17:0] ARB_TIME_SLOT_5_BINARY;
  reg [17:0] ARB_TIME_SLOT_6_BINARY;
  reg [17:0] ARB_TIME_SLOT_7_BINARY;
  reg [17:0] ARB_TIME_SLOT_8_BINARY;
  reg [17:0] ARB_TIME_SLOT_9_BINARY;
  reg [1:0] CAL_DELAY_BINARY;
  reg [1:0] MEM_CA_SIZE_BINARY;
  reg [1:0] MEM_DDR2_RTT_BINARY;
  reg [1:0] MEM_DDR3_ADD_LATENCY_BINARY;
  reg [1:0] MEM_DDR3_DYN_WRT_ODT_BINARY;
  reg [1:0] MEM_DDR3_ODS_BINARY;
  reg [1:0] MEM_MOBILE_TC_SR_BINARY;
  reg [1:0] MEM_RA_SIZE_BINARY;
  reg [1:0] MEM_WIDTH_BINARY;
  reg [2:0] CAL_CLK_DIV_BINARY;
  reg [2:0] MEM_CAS_LATENCY_BINARY;
  reg [2:0] MEM_DDR2_3_PA_SR_BINARY;
  reg [2:0] MEM_DDR2_ADD_LATENCY_BINARY;
  reg [2:0] MEM_DDR2_WRT_RECOVERY_BINARY;
  reg [2:0] MEM_DDR3_CAS_WR_LATENCY_BINARY;
  reg [2:0] MEM_DDR3_RTT_BINARY;
  reg [2:0] MEM_DDR3_WRT_RECOVERY_BINARY;
  reg [2:0] MEM_MDDR_ODS_BINARY;
  reg [2:0] MEM_MOBILE_PA_SR_BINARY;
  reg [2:0] MEM_RCD_VAL_BINARY;
  reg [2:0] MEM_RTP_VAL_BINARY;
  reg [2:0] MEM_TYPE_BINARY;
  reg [2:0] MEM_WR_VAL_BINARY;
  reg [2:0] MEM_WTR_VAL_BINARY;
  reg [3:0] MEM_DDR3_CAS_LATENCY_BINARY;
  reg [3:0] MEM_RP_VAL_BINARY;
  reg [4:0] MEM_RAS_VAL_BINARY;
  reg [7:0] MEM_RFC_VAL_BINARY;

  tri0 GSR = glbl.GSR;

  initial begin
    case (ARB_NUM_TIME_SLOTS)
      12 : ARB_NUM_TIME_SLOTS_BINARY = 1'b1;
      10 : ARB_NUM_TIME_SLOTS_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute ARB_NUM_TIME_SLOTS on MCB instance %m is set to %d.  Legal values for this attribute are 12 or 10.", ARB_NUM_TIME_SLOTS);
        $finish;
      end
    endcase

    case (CAL_BYPASS)
      "YES" : CAL_BYPASS_BINARY = 1'b1;
      "NO" : CAL_BYPASS_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_BYPASS on MCB instance %m is set to %s.  Legal values for this attribute are YES, or NO.", CAL_BYPASS);
        $finish;
      end
    endcase

    case (CAL_CALIBRATION_MODE)
      "CALIBRATION" : CAL_CALIBRATION_MODE_BINARY = 1'b0;
      "NOCALIBRATION" : CAL_CALIBRATION_MODE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_CALIBRATION_MODE on MCB instance %m is set to %s.  Legal values for this attribute are CALIBRATION, or NOCALIBRATION.", CAL_CALIBRATION_MODE);
        $finish;
      end
    endcase

    case (CAL_CLK_DIV)
      1 : CAL_CLK_DIV_BINARY = 3'b000;
      2 : CAL_CLK_DIV_BINARY = 3'b001;
      4 : CAL_CLK_DIV_BINARY = 3'b010;
      8 : CAL_CLK_DIV_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_CLK_DIV on MCB instance %m is set to %d.  Legal values for this attribute are 1, 2, 4 or 8.", CAL_CLK_DIV);
        $finish;
      end
    endcase

    case (CAL_DELAY)
      "QUARTER" : CAL_DELAY_BINARY = 2'b00;
      "FULL" : CAL_DELAY_BINARY = 2'b11;
      "HALF" : CAL_DELAY_BINARY = 2'b01;
      "THREEQUARTER" : CAL_DELAY_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute CAL_DELAY on MCB instance %m is set to %s.  Legal values for this attribute are QUARTER, FULL, HALF, or THREEQUARTER.", CAL_DELAY);
        $finish;
      end
    endcase

    case (MEM_ADDR_ORDER)
      "BANK_ROW_COLUMN" : MEM_ADDR_ORDER_BINARY = 1'b0;
      "ROW_BANK_COLUMN" : MEM_ADDR_ORDER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_ADDR_ORDER on MCB instance %m is set to %s.  Legal values for this attribute are BANK_ROW_COLUMN, or ROW_BANK_COLUMN.", MEM_ADDR_ORDER);
        $finish;
      end
    endcase

    case (MEM_BA_SIZE)
      3 : MEM_BA_SIZE_BINARY = 1'b1;
      2 : MEM_BA_SIZE_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_BA_SIZE on MCB instance %m is set to %d.  Legal values for this attribute are 2 to 3 .", MEM_BA_SIZE);
        $finish;
      end
    endcase

    case (MEM_CA_SIZE)
      11 : MEM_CA_SIZE_BINARY = 2'b10;
      9 : MEM_CA_SIZE_BINARY = 2'b00;
      10 : MEM_CA_SIZE_BINARY = 2'b01;
      12 : MEM_CA_SIZE_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_CA_SIZE on MCB instance %m is set to %d.  Legal values for this attribute are 9 to 12.", MEM_CA_SIZE);
        $finish;
      end
    endcase
     case (MEM_TYPE)
      "DDR3" : MEM_TYPE_BINARY = 3'b000;
      "DDR" : MEM_TYPE_BINARY = 3'b010;
      "DDR2" : MEM_TYPE_BINARY = 3'b001;
      "MDDR" : MEM_TYPE_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_TYPE on MCB instance %m is set to %s.  Legal values for this attribute are DDR3, DDR, DDR2, or MDDR.", MEM_TYPE);
        $finish;
      end
    endcase

    case (MEM_WIDTH)
      4 : MEM_WIDTH_BINARY = 2'b01;
      8 : MEM_WIDTH_BINARY = 2'b10;
      16 : MEM_WIDTH_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_WIDTH on MCB instance %m is set to %d.  Legal values for this attribute are 4, 8 or 16.", MEM_WIDTH);
        $finish;
      end
    endcase

    case(MEM_BURST_LEN)
      4  : if(MEM_TYPE ==  "DDR3") begin
                 $display("Attribute Syntax Error : The Attribute MEM_BURST_LEN on MEMC instance %m is set to %s.  This parameter cannot be set to 4 for MEM_TYPE DDR3.", MEM_BURST_LEN);
                 $finish;
               end
               else
               MEM_BURST_LEN_BINARY = 3'b010;
      8  : MEM_BURST_LEN_BINARY = 3'b011;
      default : begin
       $display("Attribute Syntax Error : The Attribute MEM_BURST_LEN on MEMC instance %m is set to %s.  Legal values for this attribute are 2, 4 and 8.", MEM_BURST_LEN);
       $finish;
      end
    endcase

    if((MEM_TYPE == "DDR2") || (MEM_TYPE == "DDR")) begin
      case (MEM_DDR1_2_ODS)
      "FULL" : MEM_DDR1_2_ODS_BINARY = 1'b0;
      "REDUCED" : MEM_DDR1_2_ODS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR1_2_ODS on MCB instance %m is set to %s.  Legal values for this attribute are FULL, or REDUCED.", MEM_DDR1_2_ODS);
        $finish;
      end
      endcase
    end

    if((MEM_TYPE == "DDR2") || (MEM_TYPE == "DDR3")) begin
      case (MEM_DDR2_3_HIGH_TEMP_SR)
      "NORMAL" : MEM_DDR2_3_HIGH_TEMP_SR_BINARY = 1'b0;
      "EXTENDED" : MEM_DDR2_3_HIGH_TEMP_SR_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_3_HIGH_TEMP_SR on MCB instance %m is set to %s.  Legal values for this attribute are NORMAL, or EXTENDED.", MEM_DDR2_3_HIGH_TEMP_SR);
        $finish;
      end
      endcase

      case (MEM_DDR2_3_PA_SR)
      "FULL" : MEM_DDR2_3_PA_SR_BINARY = 3'b000;
      "EIGHTH1" : MEM_DDR2_3_PA_SR_BINARY = 3'b011;
      "EIGHTH2" : MEM_DDR2_3_PA_SR_BINARY = 3'b111;
      "HALF1" : MEM_DDR2_3_PA_SR_BINARY = 3'b001;
      "HALF2" : MEM_DDR2_3_PA_SR_BINARY = 3'b101;
      "QUARTER1" : MEM_DDR2_3_PA_SR_BINARY = 3'b010;
      "QUARTER2" : MEM_DDR2_3_PA_SR_BINARY = 3'b110;
      "THREEQUARTER" : MEM_DDR2_3_PA_SR_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_3_PA_SR on MCB instance %m is set to %s.  Legal values for this attribute are FULL, EIGHTH1, EIGHTH2, HALF1, HALF2, QUARTER1, QUARTER2, or THREEQUARTER.", MEM_DDR2_3_PA_SR);
        $finish;
      end
      endcase
    end
   
    if (MEM_TYPE == "DDR2") begin
      case (MEM_DDR2_DIFF_DQS_EN)
      "YES" : MEM_DDR2_DIFF_DQS_EN_BINARY = 1'b0;
      "NO" : MEM_DDR2_DIFF_DQS_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_DIFF_DQS_EN on MCB instance %m is set to %s.  Legal values for this attribute are YES, or NO.", MEM_DDR2_DIFF_DQS_EN);
        $finish;
      end
      endcase

      case (MEM_DDR2_RTT)
      "50OHMS" : MEM_DDR2_RTT_BINARY = 2'b11;
      "75OHMS" : MEM_DDR2_RTT_BINARY = 2'b01;
      "150OHMS" : MEM_DDR2_RTT_BINARY = 2'b10;
      "OFF" : MEM_DDR2_RTT_BINARY = 2'b00;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_RTT on MCB instance %m is set to %s.  Legal values for this attribute are 50OHMS, 75OHMS, 150OHMS, or OFF.", MEM_DDR2_RTT);
        $finish;
      end
      endcase

      case (MEM_DDR2_WRT_RECOVERY)
      4 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b011;
      2 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b001;
      3 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b010;
      5 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b100;
      6 : MEM_DDR2_WRT_RECOVERY_BINARY = 3'b101;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR2_WRT_RECOVERY on MCB instance %m is set to %d.  Legal values for this attribute are 2 to 6.", MEM_DDR2_WRT_RECOVERY);
        $finish;
      end
      endcase
      if ((MEM_DDR2_ADD_LATENCY >= 0) && (MEM_DDR2_ADD_LATENCY <= 5))
      MEM_DDR2_ADD_LATENCY_BINARY = MEM_DDR2_ADD_LATENCY;
      else begin
      $display("Attribute Syntax Error : The Attribute MEM_DDR2_ADD_LATENCY on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 5.", MEM_DDR2_ADD_LATENCY);
      $finish;
      end
    end 

    if (MEM_TYPE == "DDR3") begin
      case (MEM_DDR3_ADD_LATENCY)
      "OFF" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b00;
      "CL1" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b01;
      "CL2" : MEM_DDR3_ADD_LATENCY_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_ADD_LATENCY on MCB instance %m is set to %s.  Legal values for this attribute are OFF, CL1, or CL2.", MEM_DDR3_ADD_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_AUTO_SR)
      "ENABLED" : MEM_DDR3_AUTO_SR_BINARY = 1'b1;
      "MANUAL" : MEM_DDR3_AUTO_SR_BINARY = 1'b0;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_AUTO_SR on MCB instance %m is set to %s.  Legal values for this attribute are ENABLED, or MANUAL.", MEM_DDR3_AUTO_SR);
        $finish;
      end
      endcase

      case (MEM_DDR3_CAS_LATENCY)
      7 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0110;
      5 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0010;
      6 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b0100;
      8 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1000;
      9 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1010;
      10 : MEM_DDR3_CAS_LATENCY_BINARY = 4'b1100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_CAS_LATENCY on MCB instance %m is set to %d.  Legal values for this attribute are 5 to 10.", MEM_DDR3_CAS_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_CAS_WR_LATENCY)
      5 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b000;
      6 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b001;
      7 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b010;
      8 : MEM_DDR3_CAS_WR_LATENCY_BINARY = 3'b011;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_CAS_WR_LATENCY on MCB instance %m is set to %d.  Legal values for this attribute are 5 to 8.", MEM_DDR3_CAS_WR_LATENCY);
        $finish;
      end
      endcase

      case (MEM_DDR3_DYN_WRT_ODT)
      "OFF" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b00;
      "DIV2" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b01;
      "DIV4" : MEM_DDR3_DYN_WRT_ODT_BINARY = 2'b10;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_DYN_WRT_ODT on MCB instance %m is set to %s.  Legal values for this attribute are OFF, DIV2, or DIV4.", MEM_DDR3_DYN_WRT_ODT);
        $finish;
      end
      endcase

      case (MEM_DDR3_ODS)
      "DIV7" : MEM_DDR3_ODS_BINARY = 2'b01;
      "DIV6" : MEM_DDR3_ODS_BINARY = 2'b00;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_ODS on MCB instance %m is set to %s.  Legal values for this attribute are DIV7, or DIV6.", MEM_DDR3_ODS);
        $finish;
      end
      endcase

      case (MEM_DDR3_RTT)
      "DIV2" : MEM_DDR3_RTT_BINARY = 3'b010;
      "DIV4" : MEM_DDR3_RTT_BINARY = 3'b001;
      "DIV6" : MEM_DDR3_RTT_BINARY = 3'b011;
      "DIV8" : MEM_DDR3_RTT_BINARY = 3'b100;
      "DIV12" : MEM_DDR3_RTT_BINARY = 3'b101;
      "OFF" : MEM_DDR3_RTT_BINARY = 3'b000;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_RTT on MCB instance %m is set to %s.  Legal values for this attribute are DIV2, DIV4, DIV6, DIV8, DIV12, or OFF.", MEM_DDR3_RTT);
        $finish;
      end
      endcase

      case (MEM_DDR3_WRT_RECOVERY)
      7 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b011;
      5 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b001;
      6 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b010;
      8 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b100;
      10 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b101;
      12 : MEM_DDR3_WRT_RECOVERY_BINARY = 3'b110;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_DDR3_WRT_RECOVERY on MCB instance %m is set to %d.  Legal values for this attribute are 5, 6, 7, 8, 10 or 12.", MEM_DDR3_WRT_RECOVERY);
        $finish;
      end
      endcase
    end
    
    if(MEM_TYPE == "MDDR") begin
      case (MEM_MDDR_ODS)
      "FULL" : MEM_MDDR_ODS_BINARY = 3'b000;
      "HALF" : MEM_MDDR_ODS_BINARY = 3'b001;
      "QUARTER" : MEM_MDDR_ODS_BINARY = 3'b010;
      "THREEQUARTERS" : MEM_MDDR_ODS_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_MDDR_ODS on MCB instance %m is set to %s.  Legal values for this attribute are FULL, HALF, QUARTER, or THREEQUARTERS.", MEM_MDDR_ODS);
        $finish;
      end
      endcase

      case (MEM_MOBILE_PA_SR)
      "FULL" : MEM_MOBILE_PA_SR_BINARY = 3'b000;
      "HALF" : MEM_MOBILE_PA_SR_BINARY = 3'b001;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_MOBILE_PA_SR on MCB instance %m is set to %s.  Legal values for this attribute are FULL, or HALF.", MEM_MOBILE_PA_SR);
        $finish;
      end
      endcase
      if ((MEM_MOBILE_TC_SR >= 0) && (MEM_MOBILE_TC_SR <= 3))
      MEM_MOBILE_TC_SR_BINARY = MEM_MOBILE_TC_SR;
      else begin
      $display("Attribute Syntax Error : The Attribute MEM_MOBILE_TC_SR on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 3.", MEM_MOBILE_TC_SR);
      $finish;
      end
    end

    case (MEM_RA_SIZE)
      13 : MEM_RA_SIZE_BINARY = 2'b01;
      12 : MEM_RA_SIZE_BINARY = 2'b00;
      14 : MEM_RA_SIZE_BINARY = 2'b10;
      15 : MEM_RA_SIZE_BINARY = 2'b11;
      default : begin
        $display("Attribute Syntax Error : The Attribute MEM_RA_SIZE on MCB instance %m is set to %d.  Legal values for this attribute are 12 to 15.", MEM_RA_SIZE);
        $finish;
      end
    endcase

   if ((MEM_CAS_LATENCY >= 1) && (MEM_CAS_LATENCY <= 6))
      MEM_CAS_LATENCY_BINARY = MEM_CAS_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_CAS_LATENCY on MCB instance %m is set to %d.  Legal values for this attribute are  1 to 6.", MEM_CAS_LATENCY);
      $finish;
    end
   
    if ((MEM_RAS_VAL >= 0) && (MEM_RAS_VAL <= 31))
      MEM_RAS_VAL_BINARY = MEM_RAS_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RAS_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 31.", MEM_RAS_VAL);
      $finish;
    end

    if ((MEM_RCD_VAL >= 0) && (MEM_RCD_VAL <= 7))
      MEM_RCD_VAL_BINARY = MEM_RCD_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RCD_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_RCD_VAL);
      $finish;
    end

    if ((MEM_REFI_VAL >= 0) && (MEM_REFI_VAL <= 4095))
      MEM_REFI_VAL_BINARY = MEM_REFI_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_REFI_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 4095.", MEM_REFI_VAL);
      $finish;
    end

    if ((MEM_RFC_VAL >= 0) && (MEM_RFC_VAL <= 255))
      MEM_RFC_VAL_BINARY = MEM_RFC_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RFC_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 255.", MEM_RFC_VAL);
      $finish;
    end

    if ((MEM_RP_VAL >= 0) && (MEM_RP_VAL <= 15))
      MEM_RP_VAL_BINARY = MEM_RP_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RP_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 15.", MEM_RP_VAL);
      $finish;
    end

    if ((MEM_RTP_VAL >= 0) && (MEM_RTP_VAL <= 7))
      MEM_RTP_VAL_BINARY = MEM_RTP_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_RTP_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_RTP_VAL);
      $finish;
    end

    if ((MEM_WR_VAL >= 0) && (MEM_WR_VAL <= 7))
      MEM_WR_VAL_BINARY = MEM_WR_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_WR_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_WR_VAL);
      $finish;
    end

    if ((MEM_WTR_VAL >= 0) && (MEM_WTR_VAL <= 7))
      MEM_WTR_VAL_BINARY = MEM_WTR_VAL;
    else begin
      $display("Attribute Syntax Error : The Attribute MEM_WTR_VAL on MCB instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MEM_WTR_VAL);
      $finish;
    end
    case (PORT_CONFIG)
      "B32_B32_B32_B32" : PORT_CONFIG_BINARY = 3'b001;
      "B32_B32_R32_R32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_R32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_R32_W32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_R32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_R32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_R32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_W32_R32" : PORT_CONFIG_BINARY = 3'b000;
      "B32_B32_W32_W32_W32_W32" : PORT_CONFIG_BINARY = 3'b000;
      "B64_B32_B32" : PORT_CONFIG_BINARY = 3'b010;
      "B64_B64" : PORT_CONFIG_BINARY = 3'b011;
      "B128" : PORT_CONFIG_BINARY = 3'b100;
      default : begin
        $display("Attribute Syntax Error : The Attribute PORT_CONFIG on MCB instance %m is set to %s.  Legal values for this attribute are B32_B32_B32_B32, B32_B32_R32_R32_R32_R32, B32_B32_R32_R32_R32_W32, B32_B32_R32_R32_W32_R32, B32_B32_R32_R32_W32_W32, B32_B32_R32_W32_R32_R32, B32_B32_R32_W32_R32_W32, B32_B32_R32_W32_W32_R32, B32_B32_R32_W32_W32_W32, B32_B32_W32_R32_R32_R32, B32_B32_W32_R32_R32_W32, B32_B32_W32_R32_W32_R32, B32_B32_W32_R32_W32_W32, B32_B32_W32_W32_R32_R32, B32_B32_W32_W32_R32_W32, B32_B32_W32_W32_W32_R32, B32_B32_W32_W32_W32_W32, B64_B32_B32, B64_B64, or B128.", PORT_CONFIG);
        $finish;
      end
    endcase
  end

  wire [14:0] delay_ADDR;
  wire [15:0] delay_DQON;
  wire [15:0] delay_DQOP;
  wire [2:0] delay_BA;
  wire [31:0] delay_P0RDDATA;
  wire [31:0] delay_P1RDDATA;
  wire [31:0] delay_P2RDDATA;
  wire [31:0] delay_P3RDDATA;
  wire [31:0] delay_P4RDDATA;
  wire [31:0] delay_P5RDDATA;
  wire [31:0] delay_STATUS;
  wire [4:0] delay_IOIDRPADDR;
  wire [6:0] delay_P0RDCOUNT;
  wire [6:0] delay_P0WRCOUNT;
  wire [6:0] delay_P1RDCOUNT;
  wire [6:0] delay_P1WRCOUNT;
  wire [6:0] delay_P2COUNT;
  wire [6:0] delay_P3COUNT;
  wire [6:0] delay_P4COUNT;
  wire [6:0] delay_P5COUNT;
  wire [7:0] delay_UODATA;
  wire delay_CAS;
  wire delay_CKE;
  wire delay_DQIOWEN0;
  wire delay_DQSIOWEN90N;
  wire delay_DQSIOWEN90P;
  wire delay_IOIDRPADD;
  wire delay_IOIDRPBROADCAST;
  wire delay_IOIDRPCLK;
  wire delay_IOIDRPCS;
  wire delay_IOIDRPSDO;
  wire delay_IOIDRPTRAIN;
  wire delay_IOIDRPUPDATE;
  wire delay_LDMN;
  wire delay_LDMP;
  wire delay_ODT;
  wire delay_P0CMDEMPTY;
  wire delay_P0CMDFULL;
  wire delay_P0RDEMPTY;
  wire delay_P0RDERROR;
  wire delay_P0RDFULL;
  wire delay_P0RDOVERFLOW;
  wire delay_P0WREMPTY;
  wire delay_P0WRERROR;
  wire delay_P0WRFULL;
  wire delay_P0WRUNDERRUN;
  wire delay_P1CMDEMPTY;
  wire delay_P1CMDFULL;
  wire delay_P1RDEMPTY;
  wire delay_P1RDERROR;
  wire delay_P1RDFULL;
  wire delay_P1RDOVERFLOW;
  wire delay_P1WREMPTY;
  wire delay_P1WRERROR;
  wire delay_P1WRFULL;
  wire delay_P1WRUNDERRUN;
  wire delay_P2CMDEMPTY;
  wire delay_P2CMDFULL;
  wire delay_P2EMPTY;
  wire delay_P2ERROR;
  wire delay_P2FULL;
  wire delay_P2RDOVERFLOW;
  wire delay_P2WRUNDERRUN;
  wire delay_P3CMDEMPTY;
  wire delay_P3CMDFULL;
  wire delay_P3EMPTY;
  wire delay_P3ERROR;
  wire delay_P3FULL;
  wire delay_P3RDOVERFLOW;
  wire delay_P3WRUNDERRUN;
  wire delay_P4CMDEMPTY;
  wire delay_P4CMDFULL;
  wire delay_P4EMPTY;
  wire delay_P4ERROR;
  wire delay_P4FULL;
  wire delay_P4RDOVERFLOW;
  wire delay_P4WRUNDERRUN;
  wire delay_P5CMDEMPTY;
  wire delay_P5CMDFULL;
  wire delay_P5EMPTY;
  wire delay_P5ERROR;
  wire delay_P5FULL;
  wire delay_P5RDOVERFLOW;
  wire delay_P5WRUNDERRUN;
  wire delay_RAS;
  wire delay_RST;
  wire delay_SELFREFRESHMODE;
  wire delay_UDMN;
  wire delay_UDMP;
  wire delay_UOCALSTART;
  wire delay_UOCMDREADYIN;
  wire delay_UODATAVALID;
  wire delay_UODONECAL;
  wire delay_UOREFRSHFLAG;
  wire delay_UOSDO;
  wire delay_WE;

  wire [11:0] delay_P0CMDCA;
  wire [11:0] delay_P1CMDCA;
  wire [11:0] delay_P2CMDCA;
  wire [11:0] delay_P3CMDCA;
  wire [11:0] delay_P4CMDCA;
  wire [11:0] delay_P5CMDCA;
  wire [14:0] delay_P0CMDRA;
  wire [14:0] delay_P1CMDRA;
  wire [14:0] delay_P2CMDRA;
  wire [14:0] delay_P3CMDRA;
  wire [14:0] delay_P4CMDRA;
  wire [14:0] delay_P5CMDRA;
  wire [15:0] delay_DQI;
  wire [1:0] delay_PLLCE;
  wire [1:0] delay_PLLCLK;
  wire [2:0] delay_P0CMDBA;
  wire [2:0] delay_P0CMDINSTR;
  wire [2:0] delay_P1CMDBA;
  wire [2:0] delay_P1CMDINSTR;
  wire [2:0] delay_P2CMDBA;
  wire [2:0] delay_P2CMDINSTR;
  wire [2:0] delay_P3CMDBA;
  wire [2:0] delay_P3CMDINSTR;
  wire [2:0] delay_P4CMDBA;
  wire [2:0] delay_P4CMDINSTR;
  wire [2:0] delay_P5CMDBA;
  wire [2:0] delay_P5CMDINSTR;
  wire [31:0] delay_P0WRDATA;
  wire [31:0] delay_P1WRDATA;
  wire [31:0] delay_P2WRDATA;
  wire [31:0] delay_P3WRDATA;
  wire [31:0] delay_P4WRDATA;
  wire [31:0] delay_P5WRDATA;
  wire [3:0] delay_P0RWRMASK;
  wire [3:0] delay_P1RWRMASK;
  wire [3:0] delay_P2WRMASK;
  wire [3:0] delay_P3WRMASK;
  wire [3:0] delay_P4WRMASK;
  wire [3:0] delay_P5WRMASK;
  wire [3:0] delay_UIDQCOUNT;
  wire [4:0] delay_UIADDR;
  wire [5:0] delay_P0CMDBL;
  wire [5:0] delay_P1CMDBL;
  wire [5:0] delay_P2CMDBL;
  wire [5:0] delay_P3CMDBL;
  wire [5:0] delay_P4CMDBL;
  wire [5:0] delay_P5CMDBL;
  wire delay_DQSIOIN;
  wire delay_DQSIOIP;
  wire delay_IOIDRPSDI;
  wire delay_P0ARBEN;
  wire delay_P0CMDCLK;
  wire delay_P0CMDEN;
  wire delay_P0RDCLK;
  wire delay_P0RDEN;
  wire delay_P0WRCLK;
  wire delay_P0WREN;
  wire delay_P1ARBEN;
  wire delay_P1CMDCLK;
  wire delay_P1CMDEN;
  wire delay_P1RDCLK;
  wire delay_P1RDEN;
  wire delay_P1WRCLK;
  wire delay_P1WREN;
  wire delay_P2ARBEN;
  wire delay_P2CLK;
  wire delay_P2CMDCLK;
  wire delay_P2CMDEN;
  wire delay_P2EN;
  wire delay_P3ARBEN;
  wire delay_P3CLK;
  wire delay_P3CMDCLK;
  wire delay_P3CMDEN;
  wire delay_P3EN;
  wire delay_P4ARBEN;
  wire delay_P4CLK;
  wire delay_P4CMDCLK;
  wire delay_P4CMDEN;
  wire delay_P4EN;
  wire delay_P5ARBEN;
  wire delay_P5CLK;
  wire delay_P5CMDCLK;
  wire delay_P5CMDEN;
  wire delay_P5EN;
  wire delay_PLLLOCK;
  wire delay_RECAL;
  wire delay_SELFREFRESHENTER;
  wire delay_SYSRST;
  wire delay_UDQSIOIN;
  wire delay_UDQSIOIP;
  wire delay_UIADD;
  wire delay_UIBROADCAST;
  wire delay_UICLK;
  wire delay_UICMD;
  wire delay_UICMDEN;
  wire delay_UICMDIN;
  wire delay_UICS;
  wire delay_UIDONECAL;
  wire delay_UIDQLOWERDEC;
  wire delay_UIDQLOWERINC;
  wire delay_UIDQUPPERDEC;
  wire delay_UIDQUPPERINC;
  wire delay_UIDRPUPDATE;
  wire delay_UILDQSDEC;
  wire delay_UILDQSINC;
  wire delay_UIREAD;
  wire delay_UISDI;
  wire delay_UIUDQSDEC;
  wire delay_UIUDQSINC;


  assign #(out_delay) ADDR = delay_ADDR;
  assign #(out_delay) BA = delay_BA;
  assign #(out_delay) CAS = delay_CAS;
  assign #(out_delay) CKE = delay_CKE;
  assign #(out_delay) DQIOWEN0 = delay_DQIOWEN0;
  assign #(out_delay) DQON = delay_DQON;
  assign #(out_delay) DQOP = delay_DQOP;
  assign #(out_delay) DQSIOWEN90N = delay_DQSIOWEN90N;
  assign #(out_delay) DQSIOWEN90P = delay_DQSIOWEN90P;
  assign #(out_delay) IOIDRPADD = delay_IOIDRPADD;
  assign #(out_delay) IOIDRPADDR = delay_IOIDRPADDR;
  assign #(out_delay) IOIDRPBROADCAST = delay_IOIDRPBROADCAST;
  assign #(out_delay) IOIDRPCLK = delay_IOIDRPCLK;
  assign #(out_delay) IOIDRPCS = delay_IOIDRPCS;
  assign #(out_delay) IOIDRPSDO = delay_IOIDRPSDO;
  assign #(out_delay) IOIDRPTRAIN = delay_IOIDRPTRAIN;
  assign #(out_delay) IOIDRPUPDATE = delay_IOIDRPUPDATE;
  assign #(out_delay) LDMN = delay_LDMN;
  assign #(out_delay) LDMP = delay_LDMP;
  assign #(out_delay) ODT = delay_ODT;
  assign #(out_delay) P0CMDEMPTY = delay_P0CMDEMPTY;
  assign #(out_delay) P0CMDFULL = delay_P0CMDFULL;
  assign #(out_delay) P0RDCOUNT = delay_P0RDCOUNT;
  assign #(out_delay) P0RDDATA = delay_P0RDDATA;
  assign #(out_delay) P0RDEMPTY = delay_P0RDEMPTY;
  assign #(out_delay) P0RDERROR = delay_P0RDERROR;
  assign #(out_delay) P0RDFULL = delay_P0RDFULL;
  assign #(out_delay) P0RDOVERFLOW = delay_P0RDOVERFLOW;
  assign #(out_delay) P0WRCOUNT = delay_P0WRCOUNT;
  assign #(out_delay) P0WREMPTY = delay_P0WREMPTY;
  assign #(out_delay) P0WRERROR = delay_P0WRERROR;
  assign #(out_delay) P0WRFULL = delay_P0WRFULL;
  assign #(out_delay) P0WRUNDERRUN = delay_P0WRUNDERRUN;
  assign #(out_delay) P1CMDEMPTY = delay_P1CMDEMPTY;
  assign #(out_delay) P1CMDFULL = delay_P1CMDFULL;
  assign #(out_delay) P1RDCOUNT = delay_P1RDCOUNT;
  assign #(out_delay) P1RDDATA = delay_P1RDDATA;
  assign #(out_delay) P1RDEMPTY = delay_P1RDEMPTY;
  assign #(out_delay) P1RDERROR = delay_P1RDERROR;
  assign #(out_delay) P1RDFULL = delay_P1RDFULL;
  assign #(out_delay) P1RDOVERFLOW = delay_P1RDOVERFLOW;
  assign #(out_delay) P1WRCOUNT = delay_P1WRCOUNT;
  assign #(out_delay) P1WREMPTY = delay_P1WREMPTY;
  assign #(out_delay) P1WRERROR = delay_P1WRERROR;
  assign #(out_delay) P1WRFULL = delay_P1WRFULL;
  assign #(out_delay) P1WRUNDERRUN = delay_P1WRUNDERRUN;
  assign #(out_delay) P2CMDEMPTY = delay_P2CMDEMPTY;
  assign #(out_delay) P2CMDFULL = delay_P2CMDFULL;
  assign #(out_delay) P2COUNT = delay_P2COUNT;
  assign #(out_delay) P2EMPTY = delay_P2EMPTY;
  assign #(out_delay) P2ERROR = delay_P2ERROR;
  assign #(out_delay) P2FULL = delay_P2FULL;
  assign #(out_delay) P2RDDATA = delay_P2RDDATA;
  assign #(out_delay) P2RDOVERFLOW = delay_P2RDOVERFLOW;
  assign #(out_delay) P2WRUNDERRUN = delay_P2WRUNDERRUN;
  assign #(out_delay) P3CMDEMPTY = delay_P3CMDEMPTY;
  assign #(out_delay) P3CMDFULL = delay_P3CMDFULL;
  assign #(out_delay) P3COUNT = delay_P3COUNT;
  assign #(out_delay) P3EMPTY = delay_P3EMPTY;
  assign #(out_delay) P3ERROR = delay_P3ERROR;
  assign #(out_delay) P3FULL = delay_P3FULL;
  assign #(out_delay) P3RDDATA = delay_P3RDDATA;
  assign #(out_delay) P3RDOVERFLOW = delay_P3RDOVERFLOW;
  assign #(out_delay) P3WRUNDERRUN = delay_P3WRUNDERRUN;
  assign #(out_delay) P4CMDEMPTY = delay_P4CMDEMPTY;
  assign #(out_delay) P4CMDFULL = delay_P4CMDFULL;
  assign #(out_delay) P4COUNT = delay_P4COUNT;
  assign #(out_delay) P4EMPTY = delay_P4EMPTY;
  assign #(out_delay) P4ERROR = delay_P4ERROR;
  assign #(out_delay) P4FULL = delay_P4FULL;
  assign #(out_delay) P4RDDATA = delay_P4RDDATA;
  assign #(out_delay) P4RDOVERFLOW = delay_P4RDOVERFLOW;
  assign #(out_delay) P4WRUNDERRUN = delay_P4WRUNDERRUN;
  assign #(out_delay) P5CMDEMPTY = delay_P5CMDEMPTY;
  assign #(out_delay) P5CMDFULL = delay_P5CMDFULL;
  assign #(out_delay) P5COUNT = delay_P5COUNT;
  assign #(out_delay) P5EMPTY = delay_P5EMPTY;
  assign #(out_delay) P5ERROR = delay_P5ERROR;
  assign #(out_delay) P5FULL = delay_P5FULL;
  assign #(out_delay) P5RDDATA = delay_P5RDDATA;
  assign #(out_delay) P5RDOVERFLOW = delay_P5RDOVERFLOW;
  assign #(out_delay) P5WRUNDERRUN = delay_P5WRUNDERRUN;
  assign #(out_delay) RAS = delay_RAS;
  assign #(out_delay) RST = delay_RST;
  assign #(out_delay) SELFREFRESHMODE = delay_SELFREFRESHMODE;
  assign #(out_delay) STATUS = delay_STATUS;
  assign #(out_delay) UDMN = delay_UDMN;
  assign #(out_delay) UDMP = delay_UDMP;
  assign #(out_delay) UOCALSTART = delay_UOCALSTART;
  assign #(out_delay) UOCMDREADYIN = delay_UOCMDREADYIN;
  assign #(out_delay) UODATA = delay_UODATA;
  assign #(out_delay) UODATAVALID = delay_UODATAVALID;
  assign #(out_delay) UODONECAL = delay_UODONECAL;
  assign #(out_delay) UOREFRSHFLAG = delay_UOREFRSHFLAG;
  assign #(out_delay) UOSDO = delay_UOSDO;
  assign #(out_delay) WE = delay_WE;

  assign #(INCLK_DELAY) delay_DQSIOIN = DQSIOIN;
  assign #(INCLK_DELAY) delay_DQSIOIP = DQSIOIP;
  assign #(INCLK_DELAY) delay_P0CMDCLK = P0CMDCLK;
  assign #(INCLK_DELAY) delay_P0RDCLK = P0RDCLK;
  assign #(INCLK_DELAY) delay_P0WRCLK = P0WRCLK;
  assign #(INCLK_DELAY) delay_P1CMDCLK = P1CMDCLK;
  assign #(INCLK_DELAY) delay_P1RDCLK = P1RDCLK;
  assign #(INCLK_DELAY) delay_P1WRCLK = P1WRCLK;
  assign #(INCLK_DELAY) delay_P2CLK = P2CLK;
  assign #(INCLK_DELAY) delay_P2CMDCLK = P2CMDCLK;
  assign #(INCLK_DELAY) delay_P3CLK = P3CLK;
  assign #(INCLK_DELAY) delay_P3CMDCLK = P3CMDCLK;
  assign #(INCLK_DELAY) delay_P4CLK = P4CLK;
  assign #(INCLK_DELAY) delay_P4CMDCLK = P4CMDCLK;
  assign #(INCLK_DELAY) delay_P5CLK = P5CLK;
  assign #(INCLK_DELAY) delay_P5CMDCLK = P5CMDCLK;
  assign #(INCLK_DELAY) delay_PLLCLK = PLLCLK;
  assign #(INCLK_DELAY) delay_UDQSIOIN = UDQSIOIN;
  assign #(INCLK_DELAY) delay_UDQSIOIP = UDQSIOIP;
  assign #(INCLK_DELAY) delay_UICLK = UICLK;

  assign #(in_delay) delay_DQI = DQI;
  assign #(in_delay) delay_IOIDRPSDI = IOIDRPSDI;
  assign #(in_delay) delay_P0ARBEN = P0ARBEN;
  assign #(in_delay) delay_P0CMDBA = P0CMDBA;
  assign #(in_delay) delay_P0CMDBL = P0CMDBL;
  assign #(in_delay) delay_P0CMDCA = P0CMDCA;
  assign #(in_delay) delay_P0CMDEN = P0CMDEN;
  assign #(in_delay) delay_P0CMDINSTR = P0CMDINSTR;
  assign #(in_delay) delay_P0CMDRA = P0CMDRA;
  assign #(in_delay) delay_P0RDEN = P0RDEN;
  assign #(in_delay) delay_P0RWRMASK = P0RWRMASK;
  assign #(in_delay) delay_P0WRDATA = P0WRDATA;
  assign #(in_delay) delay_P0WREN = P0WREN;
  assign #(in_delay) delay_P1ARBEN = P1ARBEN;
  assign #(in_delay) delay_P1CMDBA = P1CMDBA;
  assign #(in_delay) delay_P1CMDBL = P1CMDBL;
  assign #(in_delay) delay_P1CMDCA = P1CMDCA;
  assign #(in_delay) delay_P1CMDEN = P1CMDEN;
  assign #(in_delay) delay_P1CMDINSTR = P1CMDINSTR;
  assign #(in_delay) delay_P1CMDRA = P1CMDRA;
  assign #(in_delay) delay_P1RDEN = P1RDEN;
  assign #(in_delay) delay_P1RWRMASK = P1RWRMASK;
  assign #(in_delay) delay_P1WRDATA = P1WRDATA;
  assign #(in_delay) delay_P1WREN = P1WREN;
  assign #(in_delay) delay_P2ARBEN = P2ARBEN;
  assign #(in_delay) delay_P2CMDBA = P2CMDBA;
  assign #(in_delay) delay_P2CMDBL = P2CMDBL;
  assign #(in_delay) delay_P2CMDCA = P2CMDCA;
  assign #(in_delay) delay_P2CMDEN = P2CMDEN;
  assign #(in_delay) delay_P2CMDINSTR = P2CMDINSTR;
  assign #(in_delay) delay_P2CMDRA = P2CMDRA;
  assign #(in_delay) delay_P2EN = P2EN;
  assign #(in_delay) delay_P2WRDATA = P2WRDATA;
  assign #(in_delay) delay_P2WRMASK = P2WRMASK;
  assign #(in_delay) delay_P3ARBEN = P3ARBEN;
  assign #(in_delay) delay_P3CMDBA = P3CMDBA;
  assign #(in_delay) delay_P3CMDBL = P3CMDBL;
  assign #(in_delay) delay_P3CMDCA = P3CMDCA;
  assign #(in_delay) delay_P3CMDEN = P3CMDEN;
  assign #(in_delay) delay_P3CMDINSTR = P3CMDINSTR;
  assign #(in_delay) delay_P3CMDRA = P3CMDRA;
  assign #(in_delay) delay_P3EN = P3EN;
  assign #(in_delay) delay_P3WRDATA = P3WRDATA;
  assign #(in_delay) delay_P3WRMASK = P3WRMASK;
  assign #(in_delay) delay_P4ARBEN = P4ARBEN;
  assign #(in_delay) delay_P4CMDBA = P4CMDBA;
  assign #(in_delay) delay_P4CMDBL = P4CMDBL;
  assign #(in_delay) delay_P4CMDCA = P4CMDCA;
  assign #(in_delay) delay_P4CMDEN = P4CMDEN;
  assign #(in_delay) delay_P4CMDINSTR = P4CMDINSTR;
  assign #(in_delay) delay_P4CMDRA = P4CMDRA;
  assign #(in_delay) delay_P4EN = P4EN;
  assign #(in_delay) delay_P4WRDATA = P4WRDATA;
  assign #(in_delay) delay_P4WRMASK = P4WRMASK;
  assign #(in_delay) delay_P5ARBEN = P5ARBEN;
  assign #(in_delay) delay_P5CMDBA = P5CMDBA;
  assign #(in_delay) delay_P5CMDBL = P5CMDBL;
  assign #(in_delay) delay_P5CMDCA = P5CMDCA;
  assign #(in_delay) delay_P5CMDEN = P5CMDEN;
  assign #(in_delay) delay_P5CMDINSTR = P5CMDINSTR;
  assign #(in_delay) delay_P5CMDRA = P5CMDRA;
  assign #(in_delay) delay_P5EN = P5EN;
  assign #(in_delay) delay_P5WRDATA = P5WRDATA;
  assign #(in_delay) delay_P5WRMASK = P5WRMASK;
  assign #(in_delay) delay_PLLCE = PLLCE;
  assign #(in_delay) delay_PLLLOCK = PLLLOCK;
  assign #(in_delay) delay_RECAL = RECAL;
  assign #(in_delay) delay_SELFREFRESHENTER = SELFREFRESHENTER;
  assign #(in_delay) delay_SYSRST = SYSRST;
  assign #(in_delay) delay_UIADD = UIADD;
  assign #(in_delay) delay_UIADDR = UIADDR;
  assign #(in_delay) delay_UIBROADCAST = UIBROADCAST;
  assign #(in_delay) delay_UICMD = UICMD;
  assign #(in_delay) delay_UICMDEN = UICMDEN;
  assign #(in_delay) delay_UICMDIN = UICMDIN;
  assign #(in_delay) delay_UICS = UICS;
  assign #(in_delay) delay_UIDONECAL = UIDONECAL;
  assign #(in_delay) delay_UIDQCOUNT = UIDQCOUNT;
  assign #(in_delay) delay_UIDQLOWERDEC = UIDQLOWERDEC;
  assign #(in_delay) delay_UIDQLOWERINC = UIDQLOWERINC;
  assign #(in_delay) delay_UIDQUPPERDEC = UIDQUPPERDEC;
  assign #(in_delay) delay_UIDQUPPERINC = UIDQUPPERINC;
  assign #(in_delay) delay_UIDRPUPDATE = UIDRPUPDATE;
  assign #(in_delay) delay_UILDQSDEC = UILDQSDEC;
  assign #(in_delay) delay_UILDQSINC = UILDQSINC;
  assign #(in_delay) delay_UIREAD = UIREAD;
  assign #(in_delay) delay_UISDI = UISDI;
  assign #(in_delay) delay_UIUDQSDEC = UIUDQSDEC;
  assign #(in_delay) delay_UIUDQSINC = UIUDQSINC;

  B_MCB #(
    .ARB_NUM_TIME_SLOTS (ARB_NUM_TIME_SLOTS),
    .ARB_TIME_SLOT_0 (ARB_TIME_SLOT_0),
    .ARB_TIME_SLOT_1 (ARB_TIME_SLOT_1),
    .ARB_TIME_SLOT_10 (ARB_TIME_SLOT_10),
    .ARB_TIME_SLOT_11 (ARB_TIME_SLOT_11),
    .ARB_TIME_SLOT_2 (ARB_TIME_SLOT_2),
    .ARB_TIME_SLOT_3 (ARB_TIME_SLOT_3),
    .ARB_TIME_SLOT_4 (ARB_TIME_SLOT_4),
    .ARB_TIME_SLOT_5 (ARB_TIME_SLOT_5),
    .ARB_TIME_SLOT_6 (ARB_TIME_SLOT_6),
    .ARB_TIME_SLOT_7 (ARB_TIME_SLOT_7),
    .ARB_TIME_SLOT_8 (ARB_TIME_SLOT_8),
    .ARB_TIME_SLOT_9 (ARB_TIME_SLOT_9),
    .CAL_BA (CAL_BA),
    .CAL_BYPASS (CAL_BYPASS),
    .CAL_CA (CAL_CA),
    .CAL_CALIBRATION_MODE (CAL_CALIBRATION_MODE),
    .CAL_CLK_DIV (CAL_CLK_DIV),
    .CAL_DELAY (CAL_DELAY),
    .CAL_RA (CAL_RA),
    .MEM_ADDR_ORDER (MEM_ADDR_ORDER),
    .MEM_BA_SIZE (MEM_BA_SIZE),
    .MEM_BURST_LEN (MEM_BURST_LEN),
    .MEM_CAS_LATENCY (MEM_CAS_LATENCY),
    .MEM_CA_SIZE (MEM_CA_SIZE),
    .MEM_DDR1_2_ODS (MEM_DDR1_2_ODS),
    .MEM_DDR2_3_HIGH_TEMP_SR (MEM_DDR2_3_HIGH_TEMP_SR),
    .MEM_DDR2_3_PA_SR (MEM_DDR2_3_PA_SR),
    .MEM_DDR2_ADD_LATENCY (MEM_DDR2_ADD_LATENCY),
    .MEM_DDR2_DIFF_DQS_EN (MEM_DDR2_DIFF_DQS_EN),
    .MEM_DDR2_RTT (MEM_DDR2_RTT),
    .MEM_DDR2_WRT_RECOVERY (MEM_DDR2_WRT_RECOVERY),
    .MEM_DDR3_ADD_LATENCY (MEM_DDR3_ADD_LATENCY),
    .MEM_DDR3_AUTO_SR (MEM_DDR3_AUTO_SR),
    .MEM_DDR3_CAS_LATENCY (MEM_DDR3_CAS_LATENCY),
    .MEM_DDR3_CAS_WR_LATENCY (MEM_DDR3_CAS_WR_LATENCY),
    .MEM_DDR3_DYN_WRT_ODT (MEM_DDR3_DYN_WRT_ODT),
    .MEM_DDR3_ODS (MEM_DDR3_ODS),
    .MEM_DDR3_RTT (MEM_DDR3_RTT),
    .MEM_DDR3_WRT_RECOVERY (MEM_DDR3_WRT_RECOVERY),
    .MEM_MDDR_ODS (MEM_MDDR_ODS),
    .MEM_MOBILE_PA_SR (MEM_MOBILE_PA_SR),
    .MEM_MOBILE_TC_SR (MEM_MOBILE_TC_SR),
    .MEM_RAS_VAL (MEM_RAS_VAL),
    .MEM_RA_SIZE (MEM_RA_SIZE),
    .MEM_RCD_VAL (MEM_RCD_VAL),
    .MEM_REFI_VAL (MEM_REFI_VAL),
    .MEM_RFC_VAL (MEM_RFC_VAL),
    .MEM_RP_VAL (MEM_RP_VAL),
    .MEM_RTP_VAL (MEM_RTP_VAL),
    .MEM_TYPE (MEM_TYPE),
    .MEM_WIDTH (MEM_WIDTH),
    .MEM_WR_VAL (MEM_WR_VAL),
    .MEM_WTR_VAL (MEM_WTR_VAL),
    .PORT_CONFIG (PORT_CONFIG))

    B_MCB_INST (
    .ADDR (delay_ADDR),
    .BA (delay_BA),
    .CAS (delay_CAS),
    .CKE (delay_CKE),
    .DQIOWEN0 (delay_DQIOWEN0),
    .DQON (delay_DQON),
    .DQOP (delay_DQOP),
    .DQSIOWEN90N (delay_DQSIOWEN90N),
    .DQSIOWEN90P (delay_DQSIOWEN90P),
    .IOIDRPADD (delay_IOIDRPADD),
    .IOIDRPADDR (delay_IOIDRPADDR),
    .IOIDRPBROADCAST (delay_IOIDRPBROADCAST),
    .IOIDRPCLK (delay_IOIDRPCLK),
    .IOIDRPCS (delay_IOIDRPCS),
    .IOIDRPSDO (delay_IOIDRPSDO),
    .IOIDRPTRAIN (delay_IOIDRPTRAIN),
    .IOIDRPUPDATE (delay_IOIDRPUPDATE),
    .LDMN (delay_LDMN),
    .LDMP (delay_LDMP),
    .ODT (delay_ODT),
    .P0CMDEMPTY (delay_P0CMDEMPTY),
    .P0CMDFULL (delay_P0CMDFULL),
    .P0RDCOUNT (delay_P0RDCOUNT),
    .P0RDDATA (delay_P0RDDATA),
    .P0RDEMPTY (delay_P0RDEMPTY),
    .P0RDERROR (delay_P0RDERROR),
    .P0RDFULL (delay_P0RDFULL),
    .P0RDOVERFLOW (delay_P0RDOVERFLOW),
    .P0WRCOUNT (delay_P0WRCOUNT),
    .P0WREMPTY (delay_P0WREMPTY),
    .P0WRERROR (delay_P0WRERROR),
    .P0WRFULL (delay_P0WRFULL),
    .P0WRUNDERRUN (delay_P0WRUNDERRUN),
    .P1CMDEMPTY (delay_P1CMDEMPTY),
    .P1CMDFULL (delay_P1CMDFULL),
    .P1RDCOUNT (delay_P1RDCOUNT),
    .P1RDDATA (delay_P1RDDATA),
    .P1RDEMPTY (delay_P1RDEMPTY),
    .P1RDERROR (delay_P1RDERROR),
    .P1RDFULL (delay_P1RDFULL),
    .P1RDOVERFLOW (delay_P1RDOVERFLOW),
    .P1WRCOUNT (delay_P1WRCOUNT),
    .P1WREMPTY (delay_P1WREMPTY),
    .P1WRERROR (delay_P1WRERROR),
    .P1WRFULL (delay_P1WRFULL),
    .P1WRUNDERRUN (delay_P1WRUNDERRUN),
    .P2CMDEMPTY (delay_P2CMDEMPTY),
    .P2CMDFULL (delay_P2CMDFULL),
    .P2COUNT (delay_P2COUNT),
    .P2EMPTY (delay_P2EMPTY),
    .P2ERROR (delay_P2ERROR),
    .P2FULL (delay_P2FULL),
    .P2RDDATA (delay_P2RDDATA),
    .P2RDOVERFLOW (delay_P2RDOVERFLOW),
    .P2WRUNDERRUN (delay_P2WRUNDERRUN),
    .P3CMDEMPTY (delay_P3CMDEMPTY),
    .P3CMDFULL (delay_P3CMDFULL),
    .P3COUNT (delay_P3COUNT),
    .P3EMPTY (delay_P3EMPTY),
    .P3ERROR (delay_P3ERROR),
    .P3FULL (delay_P3FULL),
    .P3RDDATA (delay_P3RDDATA),
    .P3RDOVERFLOW (delay_P3RDOVERFLOW),
    .P3WRUNDERRUN (delay_P3WRUNDERRUN),
    .P4CMDEMPTY (delay_P4CMDEMPTY),
    .P4CMDFULL (delay_P4CMDFULL),
    .P4COUNT (delay_P4COUNT),
    .P4EMPTY (delay_P4EMPTY),
    .P4ERROR (delay_P4ERROR),
    .P4FULL (delay_P4FULL),
    .P4RDDATA (delay_P4RDDATA),
    .P4RDOVERFLOW (delay_P4RDOVERFLOW),
    .P4WRUNDERRUN (delay_P4WRUNDERRUN),
    .P5CMDEMPTY (delay_P5CMDEMPTY),
    .P5CMDFULL (delay_P5CMDFULL),
    .P5COUNT (delay_P5COUNT),
    .P5EMPTY (delay_P5EMPTY),
    .P5ERROR (delay_P5ERROR),
    .P5FULL (delay_P5FULL),
    .P5RDDATA (delay_P5RDDATA),
    .P5RDOVERFLOW (delay_P5RDOVERFLOW),
    .P5WRUNDERRUN (delay_P5WRUNDERRUN),
    .RAS (delay_RAS),
    .RST (delay_RST),
    .SELFREFRESHMODE (delay_SELFREFRESHMODE),
    .STATUS (delay_STATUS),
    .UDMN (delay_UDMN),
    .UDMP (delay_UDMP),
    .UOCALSTART (delay_UOCALSTART),
    .UOCMDREADYIN (delay_UOCMDREADYIN),
    .UODATA (delay_UODATA),
    .UODATAVALID (delay_UODATAVALID),
    .UODONECAL (delay_UODONECAL),
    .UOREFRSHFLAG (delay_UOREFRSHFLAG),
    .UOSDO (delay_UOSDO),
    .WE (delay_WE),
    .DQI (delay_DQI),
    .DQSIOIN (delay_DQSIOIN),
    .DQSIOIP (delay_DQSIOIP),
    .IOIDRPSDI (delay_IOIDRPSDI),
    .P0ARBEN (delay_P0ARBEN),
    .P0CMDBA (delay_P0CMDBA),
    .P0CMDBL (delay_P0CMDBL),
    .P0CMDCA (delay_P0CMDCA),
    .P0CMDCLK (delay_P0CMDCLK),
    .P0CMDEN (delay_P0CMDEN),
    .P0CMDINSTR (delay_P0CMDINSTR),
    .P0CMDRA (delay_P0CMDRA),
    .P0RDCLK (delay_P0RDCLK),
    .P0RDEN (delay_P0RDEN),
    .P0RWRMASK (delay_P0RWRMASK),
    .P0WRCLK (delay_P0WRCLK),
    .P0WRDATA (delay_P0WRDATA),
    .P0WREN (delay_P0WREN),
    .P1ARBEN (delay_P1ARBEN),
    .P1CMDBA (delay_P1CMDBA),
    .P1CMDBL (delay_P1CMDBL),
    .P1CMDCA (delay_P1CMDCA),
    .P1CMDCLK (delay_P1CMDCLK),
    .P1CMDEN (delay_P1CMDEN),
    .P1CMDINSTR (delay_P1CMDINSTR),
    .P1CMDRA (delay_P1CMDRA),
    .P1RDCLK (delay_P1RDCLK),
    .P1RDEN (delay_P1RDEN),
    .P1RWRMASK (delay_P1RWRMASK),
    .P1WRCLK (delay_P1WRCLK),
    .P1WRDATA (delay_P1WRDATA),
    .P1WREN (delay_P1WREN),
    .P2ARBEN (delay_P2ARBEN),
    .P2CLK (delay_P2CLK),
    .P2CMDBA (delay_P2CMDBA),
    .P2CMDBL (delay_P2CMDBL),
    .P2CMDCA (delay_P2CMDCA),
    .P2CMDCLK (delay_P2CMDCLK),
    .P2CMDEN (delay_P2CMDEN),
    .P2CMDINSTR (delay_P2CMDINSTR),
    .P2CMDRA (delay_P2CMDRA),
    .P2EN (delay_P2EN),
    .P2WRDATA (delay_P2WRDATA),
    .P2WRMASK (delay_P2WRMASK),
    .P3ARBEN (delay_P3ARBEN),
    .P3CLK (delay_P3CLK),
    .P3CMDBA (delay_P3CMDBA),
    .P3CMDBL (delay_P3CMDBL),
    .P3CMDCA (delay_P3CMDCA),
    .P3CMDCLK (delay_P3CMDCLK),
    .P3CMDEN (delay_P3CMDEN),
    .P3CMDINSTR (delay_P3CMDINSTR),
    .P3CMDRA (delay_P3CMDRA),
    .P3EN (delay_P3EN),
    .P3WRDATA (delay_P3WRDATA),
    .P3WRMASK (delay_P3WRMASK),
    .P4ARBEN (delay_P4ARBEN),
    .P4CLK (delay_P4CLK),
    .P4CMDBA (delay_P4CMDBA),
    .P4CMDBL (delay_P4CMDBL),
    .P4CMDCA (delay_P4CMDCA),
    .P4CMDCLK (delay_P4CMDCLK),
    .P4CMDEN (delay_P4CMDEN),
    .P4CMDINSTR (delay_P4CMDINSTR),
    .P4CMDRA (delay_P4CMDRA),
    .P4EN (delay_P4EN),
    .P4WRDATA (delay_P4WRDATA),
    .P4WRMASK (delay_P4WRMASK),
    .P5ARBEN (delay_P5ARBEN),
    .P5CLK (delay_P5CLK),
    .P5CMDBA (delay_P5CMDBA),
    .P5CMDBL (delay_P5CMDBL),
    .P5CMDCA (delay_P5CMDCA),
    .P5CMDCLK (delay_P5CMDCLK),
    .P5CMDEN (delay_P5CMDEN),
    .P5CMDINSTR (delay_P5CMDINSTR),
    .P5CMDRA (delay_P5CMDRA),
    .P5EN (delay_P5EN),
    .P5WRDATA (delay_P5WRDATA),
    .P5WRMASK (delay_P5WRMASK),
    .PLLCE (delay_PLLCE),
    .PLLCLK (delay_PLLCLK),
    .PLLLOCK (delay_PLLLOCK),
    .RECAL (delay_RECAL),
    .SELFREFRESHENTER (delay_SELFREFRESHENTER),
    .SYSRST (delay_SYSRST),
    .UDQSIOIN (delay_UDQSIOIN),
    .UDQSIOIP (delay_UDQSIOIP),
    .UIADD (delay_UIADD),
    .UIADDR (delay_UIADDR),
    .UIBROADCAST (delay_UIBROADCAST),
    .UICLK (delay_UICLK),
    .UICMD (delay_UICMD),
    .UICMDEN (delay_UICMDEN),
    .UICMDIN (delay_UICMDIN),
    .UICS (delay_UICS),
    .UIDONECAL (delay_UIDONECAL),
    .UIDQCOUNT (delay_UIDQCOUNT),
    .UIDQLOWERDEC (delay_UIDQLOWERDEC),
    .UIDQLOWERINC (delay_UIDQLOWERINC),
    .UIDQUPPERDEC (delay_UIDQUPPERDEC),
    .UIDQUPPERINC (delay_UIDQUPPERINC),
    .UIDRPUPDATE (delay_UIDRPUPDATE),
    .UILDQSDEC (delay_UILDQSDEC),
    .UILDQSINC (delay_UILDQSINC),
    .UIREAD (delay_UIREAD),
    .UISDI (delay_UISDI),
    .UIUDQSDEC (delay_UIUDQSDEC),
    .UIUDQSINC (delay_UIUDQSINC),
    .GSR (GSR)
  );

  specify
    ( P0CMDCLK => P0CMDEMPTY) = (100, 100);
    ( P0CMDCLK => P0CMDFULL) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[0]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[1]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[2]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[3]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[4]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[5]) = (100, 100);
    ( P0RDCLK => P0RDCOUNT[6]) = (100, 100);
    ( P0RDCLK => P0RDDATA[0]) = (100, 100);
    ( P0RDCLK => P0RDDATA[10]) = (100, 100);
    ( P0RDCLK => P0RDDATA[11]) = (100, 100);
    ( P0RDCLK => P0RDDATA[12]) = (100, 100);
    ( P0RDCLK => P0RDDATA[13]) = (100, 100);
    ( P0RDCLK => P0RDDATA[14]) = (100, 100);
    ( P0RDCLK => P0RDDATA[15]) = (100, 100);
    ( P0RDCLK => P0RDDATA[16]) = (100, 100);
    ( P0RDCLK => P0RDDATA[17]) = (100, 100);
    ( P0RDCLK => P0RDDATA[18]) = (100, 100);
    ( P0RDCLK => P0RDDATA[19]) = (100, 100);
    ( P0RDCLK => P0RDDATA[1]) = (100, 100);
    ( P0RDCLK => P0RDDATA[20]) = (100, 100);
    ( P0RDCLK => P0RDDATA[21]) = (100, 100);
    ( P0RDCLK => P0RDDATA[22]) = (100, 100);
    ( P0RDCLK => P0RDDATA[23]) = (100, 100);
    ( P0RDCLK => P0RDDATA[24]) = (100, 100);
    ( P0RDCLK => P0RDDATA[25]) = (100, 100);
    ( P0RDCLK => P0RDDATA[26]) = (100, 100);
    ( P0RDCLK => P0RDDATA[27]) = (100, 100);
    ( P0RDCLK => P0RDDATA[28]) = (100, 100);
    ( P0RDCLK => P0RDDATA[29]) = (100, 100);
    ( P0RDCLK => P0RDDATA[2]) = (100, 100);
    ( P0RDCLK => P0RDDATA[30]) = (100, 100);
    ( P0RDCLK => P0RDDATA[31]) = (100, 100);
    ( P0RDCLK => P0RDDATA[3]) = (100, 100);
    ( P0RDCLK => P0RDDATA[4]) = (100, 100);
    ( P0RDCLK => P0RDDATA[5]) = (100, 100);
    ( P0RDCLK => P0RDDATA[6]) = (100, 100);
    ( P0RDCLK => P0RDDATA[7]) = (100, 100);
    ( P0RDCLK => P0RDDATA[8]) = (100, 100);
    ( P0RDCLK => P0RDDATA[9]) = (100, 100);
    ( P0RDCLK => P0RDEMPTY) = (100, 100);
    ( P0RDCLK => P0RDERROR) = (100, 100);
    ( P0RDCLK => P0RDFULL) = (100, 100);
    ( P0RDCLK => P0RDOVERFLOW) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[0]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[1]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[2]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[3]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[4]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[5]) = (100, 100);
    ( P0WRCLK => P0WRCOUNT[6]) = (100, 100);
    ( P0WRCLK => P0WREMPTY) = (100, 100);
    ( P0WRCLK => P0WRERROR) = (100, 100);
    ( P0WRCLK => P0WRFULL) = (100, 100);
    ( P0WRCLK => P0WRUNDERRUN) = (100, 100);
    ( P1CMDCLK => P1CMDEMPTY) = (100, 100);
    ( P1CMDCLK => P1CMDFULL) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[0]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[1]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[2]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[3]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[4]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[5]) = (100, 100);
    ( P1RDCLK => P1RDCOUNT[6]) = (100, 100);
    ( P1RDCLK => P1RDDATA[0]) = (100, 100);
    ( P1RDCLK => P1RDDATA[10]) = (100, 100);
    ( P1RDCLK => P1RDDATA[11]) = (100, 100);
    ( P1RDCLK => P1RDDATA[12]) = (100, 100);
    ( P1RDCLK => P1RDDATA[13]) = (100, 100);
    ( P1RDCLK => P1RDDATA[14]) = (100, 100);
    ( P1RDCLK => P1RDDATA[15]) = (100, 100);
    ( P1RDCLK => P1RDDATA[16]) = (100, 100);
    ( P1RDCLK => P1RDDATA[17]) = (100, 100);
    ( P1RDCLK => P1RDDATA[18]) = (100, 100);
    ( P1RDCLK => P1RDDATA[19]) = (100, 100);
    ( P1RDCLK => P1RDDATA[1]) = (100, 100);
    ( P1RDCLK => P1RDDATA[20]) = (100, 100);
    ( P1RDCLK => P1RDDATA[21]) = (100, 100);
    ( P1RDCLK => P1RDDATA[22]) = (100, 100);
    ( P1RDCLK => P1RDDATA[23]) = (100, 100);
    ( P1RDCLK => P1RDDATA[24]) = (100, 100);
    ( P1RDCLK => P1RDDATA[25]) = (100, 100);
    ( P1RDCLK => P1RDDATA[26]) = (100, 100);
    ( P1RDCLK => P1RDDATA[27]) = (100, 100);
    ( P1RDCLK => P1RDDATA[28]) = (100, 100);
    ( P1RDCLK => P1RDDATA[29]) = (100, 100);
    ( P1RDCLK => P1RDDATA[2]) = (100, 100);
    ( P1RDCLK => P1RDDATA[30]) = (100, 100);
    ( P1RDCLK => P1RDDATA[31]) = (100, 100);
    ( P1RDCLK => P1RDDATA[3]) = (100, 100);
    ( P1RDCLK => P1RDDATA[4]) = (100, 100);
    ( P1RDCLK => P1RDDATA[5]) = (100, 100);
    ( P1RDCLK => P1RDDATA[6]) = (100, 100);
    ( P1RDCLK => P1RDDATA[7]) = (100, 100);
    ( P1RDCLK => P1RDDATA[8]) = (100, 100);
    ( P1RDCLK => P1RDDATA[9]) = (100, 100);
    ( P1RDCLK => P1RDEMPTY) = (100, 100);
    ( P1RDCLK => P1RDERROR) = (100, 100);
    ( P1RDCLK => P1RDFULL) = (100, 100);
    ( P1RDCLK => P1RDOVERFLOW) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[0]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[1]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[2]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[3]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[4]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[5]) = (100, 100);
    ( P1WRCLK => P1WRCOUNT[6]) = (100, 100);
    ( P1WRCLK => P1WREMPTY) = (100, 100);
    ( P1WRCLK => P1WRERROR) = (100, 100);
    ( P1WRCLK => P1WRFULL) = (100, 100);
    ( P1WRCLK => P1WRUNDERRUN) = (100, 100);
    ( P2CLK => P2COUNT[0]) = (100, 100);
    ( P2CLK => P2COUNT[1]) = (100, 100);
    ( P2CLK => P2COUNT[2]) = (100, 100);
    ( P2CLK => P2COUNT[3]) = (100, 100);
    ( P2CLK => P2COUNT[4]) = (100, 100);
    ( P2CLK => P2COUNT[5]) = (100, 100);
    ( P2CLK => P2COUNT[6]) = (100, 100);
    ( P2CLK => P2EMPTY) = (100, 100);
    ( P2CLK => P2ERROR) = (100, 100);
    ( P2CLK => P2FULL) = (100, 100);
    ( P2CLK => P2RDDATA[0]) = (100, 100);
    ( P2CLK => P2RDDATA[10]) = (100, 100);
    ( P2CLK => P2RDDATA[11]) = (100, 100);
    ( P2CLK => P2RDDATA[12]) = (100, 100);
    ( P2CLK => P2RDDATA[13]) = (100, 100);
    ( P2CLK => P2RDDATA[14]) = (100, 100);
    ( P2CLK => P2RDDATA[15]) = (100, 100);
    ( P2CLK => P2RDDATA[16]) = (100, 100);
    ( P2CLK => P2RDDATA[17]) = (100, 100);
    ( P2CLK => P2RDDATA[18]) = (100, 100);
    ( P2CLK => P2RDDATA[19]) = (100, 100);
    ( P2CLK => P2RDDATA[1]) = (100, 100);
    ( P2CLK => P2RDDATA[20]) = (100, 100);
    ( P2CLK => P2RDDATA[21]) = (100, 100);
    ( P2CLK => P2RDDATA[22]) = (100, 100);
    ( P2CLK => P2RDDATA[23]) = (100, 100);
    ( P2CLK => P2RDDATA[24]) = (100, 100);
    ( P2CLK => P2RDDATA[25]) = (100, 100);
    ( P2CLK => P2RDDATA[26]) = (100, 100);
    ( P2CLK => P2RDDATA[27]) = (100, 100);
    ( P2CLK => P2RDDATA[28]) = (100, 100);
    ( P2CLK => P2RDDATA[29]) = (100, 100);
    ( P2CLK => P2RDDATA[2]) = (100, 100);
    ( P2CLK => P2RDDATA[30]) = (100, 100);
    ( P2CLK => P2RDDATA[31]) = (100, 100);
    ( P2CLK => P2RDDATA[3]) = (100, 100);
    ( P2CLK => P2RDDATA[4]) = (100, 100);
    ( P2CLK => P2RDDATA[5]) = (100, 100);
    ( P2CLK => P2RDDATA[6]) = (100, 100);
    ( P2CLK => P2RDDATA[7]) = (100, 100);
    ( P2CLK => P2RDDATA[8]) = (100, 100);
    ( P2CLK => P2RDDATA[9]) = (100, 100);
    ( P2CLK => P2RDOVERFLOW) = (100, 100);
    ( P2CLK => P2WRUNDERRUN) = (100, 100);
    ( P2CMDCLK => P2CMDEMPTY) = (100, 100);
    ( P2CMDCLK => P2CMDFULL) = (100, 100);
    ( P3CLK => P3COUNT[0]) = (100, 100);
    ( P3CLK => P3COUNT[1]) = (100, 100);
    ( P3CLK => P3COUNT[2]) = (100, 100);
    ( P3CLK => P3COUNT[3]) = (100, 100);
    ( P3CLK => P3COUNT[4]) = (100, 100);
    ( P3CLK => P3COUNT[5]) = (100, 100);
    ( P3CLK => P3COUNT[6]) = (100, 100);
    ( P3CLK => P3EMPTY) = (100, 100);
    ( P3CLK => P3ERROR) = (100, 100);
    ( P3CLK => P3FULL) = (100, 100);
    ( P3CLK => P3RDDATA[0]) = (100, 100);
    ( P3CLK => P3RDDATA[10]) = (100, 100);
    ( P3CLK => P3RDDATA[11]) = (100, 100);
    ( P3CLK => P3RDDATA[12]) = (100, 100);
    ( P3CLK => P3RDDATA[13]) = (100, 100);
    ( P3CLK => P3RDDATA[14]) = (100, 100);
    ( P3CLK => P3RDDATA[15]) = (100, 100);
    ( P3CLK => P3RDDATA[16]) = (100, 100);
    ( P3CLK => P3RDDATA[17]) = (100, 100);
    ( P3CLK => P3RDDATA[18]) = (100, 100);
    ( P3CLK => P3RDDATA[19]) = (100, 100);
    ( P3CLK => P3RDDATA[1]) = (100, 100);
    ( P3CLK => P3RDDATA[20]) = (100, 100);
    ( P3CLK => P3RDDATA[21]) = (100, 100);
    ( P3CLK => P3RDDATA[22]) = (100, 100);
    ( P3CLK => P3RDDATA[23]) = (100, 100);
    ( P3CLK => P3RDDATA[24]) = (100, 100);
    ( P3CLK => P3RDDATA[25]) = (100, 100);
    ( P3CLK => P3RDDATA[26]) = (100, 100);
    ( P3CLK => P3RDDATA[27]) = (100, 100);
    ( P3CLK => P3RDDATA[28]) = (100, 100);
    ( P3CLK => P3RDDATA[29]) = (100, 100);
    ( P3CLK => P3RDDATA[2]) = (100, 100);
    ( P3CLK => P3RDDATA[30]) = (100, 100);
    ( P3CLK => P3RDDATA[31]) = (100, 100);
    ( P3CLK => P3RDDATA[3]) = (100, 100);
    ( P3CLK => P3RDDATA[4]) = (100, 100);
    ( P3CLK => P3RDDATA[5]) = (100, 100);
    ( P3CLK => P3RDDATA[6]) = (100, 100);
    ( P3CLK => P3RDDATA[7]) = (100, 100);
    ( P3CLK => P3RDDATA[8]) = (100, 100);
    ( P3CLK => P3RDDATA[9]) = (100, 100);
    ( P3CLK => P3RDOVERFLOW) = (100, 100);
    ( P3CLK => P3WRUNDERRUN) = (100, 100);
    ( P3CMDCLK => P3CMDEMPTY) = (100, 100);
    ( P3CMDCLK => P3CMDFULL) = (100, 100);
    ( P4CLK => P4COUNT[0]) = (100, 100);
    ( P4CLK => P4COUNT[1]) = (100, 100);
    ( P4CLK => P4COUNT[2]) = (100, 100);
    ( P4CLK => P4COUNT[3]) = (100, 100);
    ( P4CLK => P4COUNT[4]) = (100, 100);
    ( P4CLK => P4COUNT[5]) = (100, 100);
    ( P4CLK => P4COUNT[6]) = (100, 100);
    ( P4CLK => P4EMPTY) = (100, 100);
    ( P4CLK => P4ERROR) = (100, 100);
    ( P4CLK => P4FULL) = (100, 100);
    ( P4CLK => P4RDDATA[0]) = (100, 100);
    ( P4CLK => P4RDDATA[10]) = (100, 100);
    ( P4CLK => P4RDDATA[11]) = (100, 100);
    ( P4CLK => P4RDDATA[12]) = (100, 100);
    ( P4CLK => P4RDDATA[13]) = (100, 100);
    ( P4CLK => P4RDDATA[14]) = (100, 100);
    ( P4CLK => P4RDDATA[15]) = (100, 100);
    ( P4CLK => P4RDDATA[16]) = (100, 100);
    ( P4CLK => P4RDDATA[17]) = (100, 100);
    ( P4CLK => P4RDDATA[18]) = (100, 100);
    ( P4CLK => P4RDDATA[19]) = (100, 100);
    ( P4CLK => P4RDDATA[1]) = (100, 100);
    ( P4CLK => P4RDDATA[20]) = (100, 100);
    ( P4CLK => P4RDDATA[21]) = (100, 100);
    ( P4CLK => P4RDDATA[22]) = (100, 100);
    ( P4CLK => P4RDDATA[23]) = (100, 100);
    ( P4CLK => P4RDDATA[24]) = (100, 100);
    ( P4CLK => P4RDDATA[25]) = (100, 100);
    ( P4CLK => P4RDDATA[26]) = (100, 100);
    ( P4CLK => P4RDDATA[27]) = (100, 100);
    ( P4CLK => P4RDDATA[28]) = (100, 100);
    ( P4CLK => P4RDDATA[29]) = (100, 100);
    ( P4CLK => P4RDDATA[2]) = (100, 100);
    ( P4CLK => P4RDDATA[30]) = (100, 100);
    ( P4CLK => P4RDDATA[31]) = (100, 100);
    ( P4CLK => P4RDDATA[3]) = (100, 100);
    ( P4CLK => P4RDDATA[4]) = (100, 100);
    ( P4CLK => P4RDDATA[5]) = (100, 100);
    ( P4CLK => P4RDDATA[6]) = (100, 100);
    ( P4CLK => P4RDDATA[7]) = (100, 100);
    ( P4CLK => P4RDDATA[8]) = (100, 100);
    ( P4CLK => P4RDDATA[9]) = (100, 100);
    ( P4CLK => P4RDOVERFLOW) = (100, 100);
    ( P4CLK => P4WRUNDERRUN) = (100, 100);
    ( P4CMDCLK => P4CMDEMPTY) = (100, 100);
    ( P4CMDCLK => P4CMDFULL) = (100, 100);
    ( P5CLK => P5COUNT[0]) = (100, 100);
    ( P5CLK => P5COUNT[1]) = (100, 100);
    ( P5CLK => P5COUNT[2]) = (100, 100);
    ( P5CLK => P5COUNT[3]) = (100, 100);
    ( P5CLK => P5COUNT[4]) = (100, 100);
    ( P5CLK => P5COUNT[5]) = (100, 100);
    ( P5CLK => P5COUNT[6]) = (100, 100);
    ( P5CLK => P5EMPTY) = (100, 100);
    ( P5CLK => P5ERROR) = (100, 100);
    ( P5CLK => P5FULL) = (100, 100);
    ( P5CLK => P5RDDATA[0]) = (100, 100);
    ( P5CLK => P5RDDATA[10]) = (100, 100);
    ( P5CLK => P5RDDATA[11]) = (100, 100);
    ( P5CLK => P5RDDATA[12]) = (100, 100);
    ( P5CLK => P5RDDATA[13]) = (100, 100);
    ( P5CLK => P5RDDATA[14]) = (100, 100);
    ( P5CLK => P5RDDATA[15]) = (100, 100);
    ( P5CLK => P5RDDATA[16]) = (100, 100);
    ( P5CLK => P5RDDATA[17]) = (100, 100);
    ( P5CLK => P5RDDATA[18]) = (100, 100);
    ( P5CLK => P5RDDATA[19]) = (100, 100);
    ( P5CLK => P5RDDATA[1]) = (100, 100);
    ( P5CLK => P5RDDATA[20]) = (100, 100);
    ( P5CLK => P5RDDATA[21]) = (100, 100);
    ( P5CLK => P5RDDATA[22]) = (100, 100);
    ( P5CLK => P5RDDATA[23]) = (100, 100);
    ( P5CLK => P5RDDATA[24]) = (100, 100);
    ( P5CLK => P5RDDATA[25]) = (100, 100);
    ( P5CLK => P5RDDATA[26]) = (100, 100);
    ( P5CLK => P5RDDATA[27]) = (100, 100);
    ( P5CLK => P5RDDATA[28]) = (100, 100);
    ( P5CLK => P5RDDATA[29]) = (100, 100);
    ( P5CLK => P5RDDATA[2]) = (100, 100);
    ( P5CLK => P5RDDATA[30]) = (100, 100);
    ( P5CLK => P5RDDATA[31]) = (100, 100);
    ( P5CLK => P5RDDATA[3]) = (100, 100);
    ( P5CLK => P5RDDATA[4]) = (100, 100);
    ( P5CLK => P5RDDATA[5]) = (100, 100);
    ( P5CLK => P5RDDATA[6]) = (100, 100);
    ( P5CLK => P5RDDATA[7]) = (100, 100);
    ( P5CLK => P5RDDATA[8]) = (100, 100);
    ( P5CLK => P5RDDATA[9]) = (100, 100);
    ( P5CLK => P5RDOVERFLOW) = (100, 100);
    ( P5CLK => P5WRUNDERRUN) = (100, 100);
    ( P5CMDCLK => P5CMDEMPTY) = (100, 100);
    ( P5CMDCLK => P5CMDFULL) = (100, 100);
    ( PLLCLK[0] => DQSIOWEN90N) = (100, 100);
    ( PLLCLK[0] => DQSIOWEN90P) = (100, 100);
    ( PLLCLK[1] => DQIOWEN0) = (100, 100);
    ( PLLCLK[1] => SELFREFRESHMODE) = (100, 100);
    ( UICLK => IOIDRPADD) = (100, 100);
    ( UICLK => IOIDRPADDR[0]) = (100, 100);
    ( UICLK => IOIDRPADDR[1]) = (100, 100);
    ( UICLK => IOIDRPADDR[2]) = (100, 100);
    ( UICLK => IOIDRPADDR[3]) = (100, 100);
    ( UICLK => IOIDRPADDR[4]) = (100, 100);
    ( UICLK => IOIDRPBROADCAST) = (100, 100);
    ( UICLK => IOIDRPCLK) = (0, 0);
    ( UICLK => IOIDRPCS) = (100, 100);
    ( UICLK => IOIDRPSDO) = (100, 100);
    ( UICLK => IOIDRPUPDATE) = (100, 100);
    ( UICLK => UOCALSTART) = (100, 100);
    ( UICLK => UOCMDREADYIN) = (100, 100);
    ( UICLK => UODATAVALID) = (100, 100);
    ( UICLK => UODATA[0]) = (100, 100);
    ( UICLK => UODATA[1]) = (100, 100);
    ( UICLK => UODATA[2]) = (100, 100);
    ( UICLK => UODATA[3]) = (100, 100);
    ( UICLK => UODATA[4]) = (100, 100);
    ( UICLK => UODATA[5]) = (100, 100);
    ( UICLK => UODATA[6]) = (100, 100);
    ( UICLK => UODATA[7]) = (100, 100);
    ( UICLK => UODONECAL) = (100, 100);
    ( UICLK => UOREFRSHFLAG) = (100, 100);
    ( UICLK => UOSDO) = (100, 100);

    specparam PATHPULSE$ = 0;
  endspecify
endmodule
